from bpy.types import Context, Object
from ....libs.functions.get_common_vars import get_common_vars
from ....addon.naming import FluidLabNaming


def props_update_canvas(self, context:Context, call_from:str) -> None:

    """ Update in bulk Canvas settings (colliders ob) """
    
    fluid_colliders = get_common_vars(context, get_fluid_colliders=True)
    active_collider = fluid_colliders.active

    for c_ob in active_collider.colliders:
        collider_ob  = c_ob.ob
        
        canvas_mod = collider_ob.modifiers.get(FluidLabNaming.DP_CANVAS_MOD)
        if not canvas_mod:
            continue
            
        settings = canvas_mod.canvas_settings
        if not settings:
            continue

        surface = settings.canvas_surfaces.active
        if not surface:
            continue
            
        # Para los effector_weights.prop_name:
        surface = surface.effector_weights if call_from.startswith("effector_weights") else surface
        prop_name = call_from.split(".")[1] if "." in call_from else call_from

        # La norma general:
        current_value = getattr(surface, prop_name)

        # sólo si el nuevo valor es distinto:
        new_value = getattr(self, prop_name)
        if current_value != new_value:
            setattr(surface, prop_name, getattr(self, prop_name))